# 简介

**作者 吴恩达教授**

欢迎来到本课程，我们将为开发人员介绍 ChatGPT 提示工程。本课程由 Isa Fulford 教授和我一起授课。Isa Fulford 是 OpenAI 的技术团队成员，曾开发过受欢迎的 ChatGPT 检索插件，并且在教授人们如何在产品中使用 LLM 或 LLM 技术方面做出了很大贡献。她还参与编写了教授人们使用 Prompt 的 OpenAI cookbook。

互联网上有很多有关提示的材料，例如《30 prompts everyone has to know》之类的文章。这些文章主要集中在 ChatGPT Web 用户界面上，许多人在使用它执行特定的、通常是一次性的任务。但是，我认为 LLM 或大型语言模型作为开发人员的更强大功能是使用 API 调用到 LLM，以快速构建软件应用程序。我认为这方面还没有得到充分的重视。实际上，我们在 DeepLearning.AI 的姊妹公司 AI Fund 的团队一直在与许多初创公司合作，将这些技术应用于许多不同的应用程序上。看到 LLM API 能够让开发人员非常快速地构建应用程序，这真是令人兴奋。

在本课程中，我们将与您分享一些可能性以及如何实现它们的最佳实践。

随着大型语言模型（LLM）的发展，LLM 大致可以分为两种类型，即基础LLM和指令微调LLM。基础LLM是基于文本训练数据，训练出预测下一个单词能力的模型，其通常是在互联网和其他来源的大量数据上训练的。例如，如果你以“从前有一只独角兽”作为提示，基础LLM可能会继续预测“生活在一个与所有独角兽朋友的神奇森林中”。但是，如果你以“法国的首都是什么”为提示，则基础LLM可能会根据互联网上的文章，将答案预测为“法国最大的城市是什么？法国的人口是多少？”，因为互联网上的文章很可能是有关法国国家的问答题目列表。

许多 LLMs 的研究和实践的动力正在指令调整的 LLMs 上。指令调整的 LLMs 已经被训练来遵循指令。因此，如果你问它，“法国的首都是什么？”，它更有可能输出“法国的首都是巴黎”。指令调整的 LLMs 的训练通常是从已经训练好的基本 LLMs 开始，该模型已经在大量文本数据上进行了训练。然后，使用输入是指令、输出是其应该返回的结果的数据集来对其进行微调，要求它遵循这些指令。然后通常使用一种称为 RLHF（reinforcement learning from human feedback，人类反馈强化学习）的技术进行进一步改进，使系统更能够有帮助地遵循指令。

因为指令调整的 LLMs 已经被训练成有益、诚实和无害的，所以与基础LLMs相比，它们更不可能输出有问题的文本，如有害输出。许多实际使用场景已经转向指令调整的LLMs。您在互联网上找到的一些最佳实践可能更适用于基础LLMs，但对于今天的大多数实际应用，我们建议将注意力集中在指令调整的LLMs上，这些LLMs更容易使用，而且由于OpenAI和其他LLM公司的工作，它们变得更加安全和更加协调。

因此，本课程将重点介绍针对指令调整 LLM 的最佳实践，这是我们建议您用于大多数应用程序的。在继续之前，我想感谢 OpenAI 和 DeepLearning.ai 团队为 Izzy 和我所提供的材料作出的贡献。我非常感激 OpenAI 的 Andrew Main、Joe Palermo、Boris Power、Ted Sanders 和 Lillian Weng，他们参与了我们的头脑风暴材料的制定和审核，为这个短期课程编制了课程大纲。我也感激 Deep Learning 方面的 Geoff Ladwig、Eddy Shyu 和 Tommy Nelson 的工作。

当您使用指令调整 LLM 时，请类似于考虑向另一个人提供指令，假设它是一个聪明但不知道您任务的具体细节的人。当 LLM 无法正常工作时，有时是因为指令不够清晰。例如，如果您说“请为我写一些关于阿兰·图灵的东西”，清楚表明您希望文本专注于他的科学工作、个人生活、历史角色或其他方面可能会更有帮助。更多的，您还可以指定文本采取像专业记者写作的语调，或者更像是您向朋友写的随笔。

当然，如果你想象一下让一位新毕业的大学生为你完成这个任务，你甚至可以提前指定他们应该阅读哪些文本片段来写关于 Alan Turing的文本，那么这能够帮助这位新毕业的大学生更好地成功完成这项任务。下一章你会看到如何让提示清晰明确，创建提示的一个重要原则，你还会从提示的第二个原则中学到给LLM时间去思考。